package ru.yandex.webmaster3.internal.user.domain;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.UserHostVerificationInfo;
import ru.yandex.webmaster3.storage.user.UserUnverifiedHost;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;

import java.util.Map;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class DomainVerificationState {
    private final Set<WebmasterHostId> allPossibleDomainHosts;
    private final Map<WebmasterHostId, UserUnverifiedHost> notVerifiedHosts;
    private final Map<WebmasterHostId, UserVerifiedHost> verifiedHosts;
    private final Map<WebmasterHostId, UserHostVerificationInfo> verificationRecords;
    private final WebmasterHostId preferredHost;

    public DomainVerificationState(
            Set<WebmasterHostId> allPossibleDomainHosts, Map<WebmasterHostId, UserUnverifiedHost> notVerifiedHosts,
            Map<WebmasterHostId, UserVerifiedHost> verifiedHosts,
            Map<WebmasterHostId, UserHostVerificationInfo> verificationRecords,
            WebmasterHostId preferredHost
    ) {
        this.allPossibleDomainHosts = allPossibleDomainHosts;
        this.notVerifiedHosts = notVerifiedHosts;
        this.verifiedHosts = verifiedHosts;
        this.verificationRecords = verificationRecords;
        this.preferredHost = preferredHost;
    }

    public Set<WebmasterHostId> getAllPossibleDomainHosts() {
        return allPossibleDomainHosts;
    }

    public Map<WebmasterHostId, UserUnverifiedHost> getNotVerifiedHosts() {
        return notVerifiedHosts;
    }

    public Map<WebmasterHostId, UserVerifiedHost> getVerifiedHosts() {
        return verifiedHosts;
    }

    public WebmasterHostId getPreferredHost() {
        return preferredHost;
    }

    public boolean isAdded(WebmasterHostId hostId) {
        return isAddedNotVerified(hostId) || isVerified(hostId);
    }

    public boolean isAddedNotVerified(WebmasterHostId hostId) {
        return notVerifiedHosts.containsKey(hostId);
    }

    public boolean isVerified(WebmasterHostId hostId) {
        return verifiedHosts.containsKey(hostId);
    }

    public Map<WebmasterHostId, UserHostVerificationInfo> getVerificationRecords() {
        return verificationRecords;
    }
}
