package ru.yandex.webmaster3.internal.user.domain.common;

import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.internal.common.InternalRequest;

/**
 * @author avhaliullin
 */
public class DomainAddedFilter<Req extends InternalRequest & AddedDomainAwareRequest> implements RequestFilter<Req, DomainAddedFilterResponse> {
    @Override
    public DomainAddedFilterResponse beforeRequest(RequestContext ctx, Req req) {
        if (!req.getDomainVerificationState().isAdded(req.getDomainVerificationState().getPreferredHost())) {
            return new DomainAddedFilterResponse.DomainNotAdded(getClass(), req.getDomainVerificationState().getPreferredHost(), req.getDomain());
        }
        return null;
    }
}
