package ru.yandex.webmaster3.internal.user.domain.common;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.filter.UserHostErrors;

/**
 * @author avhaliullin
 */
public interface DomainAddedFilterResponse extends ActionResponse.ErrorResponse {
    class DomainNotAdded extends UserHostErrors.HostNotAddedResponse implements DomainAddedFilterResponse {
        private final String domain;

        public DomainNotAdded(Class<?> clazz, WebmasterHostId hostId, String domain) {
            super(clazz, hostId);
            this.domain = domain;
        }

        @Description("домен")
        public String getDomain() {
            return domain;
        }
    }
}

