package ru.yandex.webmaster3.internal.user.domain.common;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.core.http.request.WebmasterUserIdAware;
import ru.yandex.webmaster3.internal.common.InternalRequest;
import ru.yandex.webmaster3.internal.user.domain.DomainVerificationHelperService;
import ru.yandex.webmaster3.internal.user.domain.DomainVerificationState;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class DomainVerificationStateProvidingFilter<Req extends InternalRequest & WebmasterUserIdAware & DomainAwareRequest> implements RequestFilter<Req, DomainVerificationStateProvidingFilter.Response> {
    private final DomainVerificationHelperService domainVerificationHelperService;

    @Override
    public Response beforeRequest(RequestContext ctx, Req req) {
        DomainVerificationState verificationState = domainVerificationHelperService.getDomainVerificationState(req.getUserId(), req.getDomain());
        req.setDomainVerificationState(verificationState);
        return null;
    }

    public interface Response extends ActionResponse.ErrorResponse {}
}
