package ru.yandex.webmaster3.internal.user.domain.common;

import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.internal.common.InternalRequest;
import ru.yandex.webmaster3.internal.user.domain.DomainVerificationState;

/**
 * @author avhaliullin
 */
public class DomainVerifiedFilter<Req extends InternalRequest & VerifiedDomainAwareRequest> implements RequestFilter<Req, DomainVerifiedFilterReponse> {
    @Override
    public DomainVerifiedFilterReponse beforeRequest(RequestContext ctx, Req req) {
        DomainVerificationState domainVerificationState = req.getDomainVerificationState();
        if (domainVerificationState.isVerified(domainVerificationState.getPreferredHost())) {
            return null;
        } else {
            return new DomainVerifiedFilterReponse.DomainNotVerified(getClass(), domainVerificationState.getPreferredHost(), req.getDomain());
        }
    }
}
