package ru.yandex.webmaster3.internal.user.domain.common;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.filter.UserHostErrors;

/**
 * @author avhaliullin
 */
public interface DomainVerifiedFilterReponse extends ActionResponse.ErrorResponse {
    class DomainNotVerified extends UserHostErrors.HostNotVerifiedResponse implements DomainVerifiedFilterReponse {
        private final String domain;

        public DomainNotVerified(Class<?> clazz, WebmasterHostId hostId, String domain) {
            super(clazz, hostId);
            this.domain = domain;
        }

        @Description("домен")
        public String getDomain() {
            return domain;
        }
    }
}

