package ru.yandex.webmaster3.internal.user.domain.verification;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author avhaliullin
 */
public abstract class AddDomainResponse implements ActionResponse {
    public static class NormalResponse extends AddDomainResponse implements ActionResponse.NormalResponse {
        private final WebmasterHostId hostId;
        private final String domain;
        private final boolean verified;

        public NormalResponse(WebmasterHostId hostId, String domain, boolean verified) {
            this.hostId = hostId;
            this.domain = domain;
            this.verified = verified;
        }

        @Description("id добавленного хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("добавленный домен")
        public String getDomain() {
            return domain;
        }

        @Description("права на хост автоматически подтверждены")
        public boolean isVerified() {
            return verified;
        }
    }

    public enum Errors {
        ADD_HOST__HOST_ALREADY_ADDED,
        ADD_HOST__NOT_MAIN_MIRROR,
        ADD_HOST__HOSTS_LIMIT_EXCEEDED,
    }

    public abstract static class AbstractErrorResponse extends AddDomainResponse implements ErrorResponse {
        private final Errors code;

        public AbstractErrorResponse(Errors code) {
            this.code = code;
        }

        @Override
        public Enum<?> getCode() {
            return code;
        }
    }

    @Description("Такой хост уже добавлен")
    public static class DomainAlreadyAddedError extends AbstractErrorResponse {
        private final WebmasterHostId hostId;
        private final String domain;
        private final boolean verified;

        public DomainAlreadyAddedError(WebmasterHostId hostId, String domain, boolean verified) {
            super(Errors.ADD_HOST__HOST_ALREADY_ADDED);
            this.hostId = hostId;
            this.domain = domain;
            this.verified = verified;
        }

        @Description("домен")
        public String getDomain() {
            return domain;
        }

        @Description("id хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("подтвержден ли добавленный хост")
        public boolean isVerified() {
            return verified;
        }
    }

    @Description("Превышен лимит количества хостов")
    public static class HostsLimitExceededError extends AbstractErrorResponse {
        private final int limit;

        public HostsLimitExceededError(int limit) {
            super(Errors.ADD_HOST__HOSTS_LIMIT_EXCEEDED);
            this.limit = limit;
        }

        @Description("лимит количества хостов")
        public int getLimit() {
            return limit;
        }
    }
}

