package ru.yandex.webmaster3.internal.user.domain.verification;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationTypeScope;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.internal.common.InternalAction;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;
import ru.yandex.webmaster3.storage.verification.HostVerifierService;

/**
 * @author avhaliullin
 */
@Description("Выводит список типов подтверждений, доступных для выбранного хоста")
@ReadAction
public class DomainApplicableVerificationsAction extends InternalAction<DomainApplicableVerificationsRequest, DomainApplicableVerificationsResponse> {
    DomainApplicableVerificationsAction() {
        super(InternalGrant.DOMAIN_VERIFICATION);
    }

    private HostVerifierService hostVerifierService;

    @Override
    public DomainApplicableVerificationsResponse process(DomainApplicableVerificationsRequest request) {
        return new DomainApplicableVerificationsResponse(hostVerifierService.listApplicable(
                request.getDomainVerificationState().getPreferredHost(), request.getUserId(), VerificationTypeScope.INTERNAL
        ));
    }

    @Required
    public void setHostVerifierService(HostVerifierService hostVerifierService) {
        this.hostVerifierService = hostVerifierService;
    }
}
