package ru.yandex.webmaster3.internal.user.domain.verification;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.UserHostVerificationInfo;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.internal.common.InternalAction;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;
import ru.yandex.webmaster3.internal.user.domain.DomainVerificationState;
import ru.yandex.webmaster3.storage.verification.HostVerifierService;

/**
 * @author avhaliullin
 */
@Description("Посмотреть информацию о подтверждении прав")
@ReadAction
public class DomainVerificationInfoAction extends InternalAction<DomainVerificationInfoRequest, DomainVerificationInfoResponse> {

    public DomainVerificationInfoAction() {
        super(InternalGrant.DOMAIN_VERIFICATION);
    }

    @Override
    public DomainVerificationInfoResponse process(DomainVerificationInfoRequest request) throws WebmasterException {
        DomainVerificationState verificationState = request.getDomainVerificationState();
        WebmasterHostId prefferedHostId = verificationState.getPreferredHost();
        if (verificationState.isVerified(prefferedHostId)) {
            return DomainVerificationInfoResponse.createVerified(verificationState.getVerifiedHosts().get(prefferedHostId));
        }

        UserHostVerificationInfo verificationInfo = verificationState.getVerificationRecords().get(prefferedHostId);
        if (verificationInfo.getVerificationStatus() == null) {
            return DomainVerificationInfoResponse.createNeverVerified(verificationInfo);
        } else if (HostVerifierService.isVerificationExpired(verificationInfo)) {
            return DomainVerificationInfoResponse.createExpired(verificationInfo);
        }

        return DomainVerificationInfoResponse.createNotVerified(verificationInfo);
    }

}
