package ru.yandex.webmaster3.internal.user.host;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.internal.common.InternalRequest;

import java.util.Set;

/**
 * @author avhaliullin
 */
public class BatchGetHostsOwnershipInfoRequest extends InternalRequest {
    private Set<WebmasterHostId> hostIds;
    private boolean showInvisible = false;

    public Set<WebmasterHostId> getHostIds() {
        return hostIds;
    }

    @RequestQueryProperty(required = true)
    public void setHostIds(Set<WebmasterHostId> hostIds) {
        this.hostIds = hostIds;
    }

    public boolean isShowInvisible() {
        return showInvisible;
    }

    @Description("Учитывать ли специальные виды подтверждений")
    @RequestQueryProperty()
    public void setShowInvisible(boolean showInvisible) {
        this.showInvisible = showInvisible;
    }
}
