package ru.yandex.webmaster3.internal.user.host;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.List;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class BatchGetHostsOwnershipInfoResponse implements ActionResponse.NormalResponse {
    private final List<HostInfo> hosts;

    public BatchGetHostsOwnershipInfoResponse(List<HostInfo> hosts) {
        this.hosts = hosts;
    }

    public List<HostInfo> getHosts() {
        return hosts;
    }

    public static class HostInfo {
        private final WebmasterHostId hostId;
        private final Set<Long> owners;

        public HostInfo(WebmasterHostId hostId, Set<Long> owners) {
            this.hostId = hostId;
            this.owners = owners;
        }

        public WebmasterHostId getHostId() {
            return hostId;
        }

        public Set<Long> getOwners() {
            return owners;
        }
    }
}
