package ru.yandex.webmaster3.internal.user.host;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.internal.common.InternalRequest;

import java.util.List;

/**
 * @author avhaliullin
 */
public class BatchHostIsVerifiedByUserRequest extends InternalRequest {
    private List<UserHostQuery> usersHosts;
    private boolean showInvisible = true;

    @Description("Пары пользователь+хост, для которых нужно выполнить проверку")
    @RequestPostProperty(required = true)
    public void setUsersHosts(List<UserHostQuery> usersHosts) {
        this.usersHosts = usersHosts;
    }

    public List<UserHostQuery> getUsersHosts() {
        return usersHosts;
    }

    public boolean isShowInvisible() {
        return showInvisible;
    }

    @Description("Учитывать ли специальные виды подтверждений")
    @RequestQueryProperty()
    public void setShowInvisible(boolean showInvisible) {
        this.showInvisible = showInvisible;
    }
}
