package ru.yandex.webmaster3.internal.user.host;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;

import java.util.List;
import java.util.Set;

/**
 * @author avhaliullin
 */
public abstract class BatchHostIsVerifiedByUserResponse implements ActionResponse {
    public static class NormalResponse extends BatchHostIsVerifiedByUserResponse {
        private final List<UserHostResult> results;

        public NormalResponse(List<UserHostResult> results) {
            this.results = results;
        }

        @Description("список пар пользователь+хост с состоянием подтверждения")
        public List<UserHostResult> getResults() {
            return results;
        }

        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }

    public enum Errors {
        INVALID_HOST_ADDRESSES;
    }

    public static class InvalidHostAddressesResponse extends BatchHostIsVerifiedByUserResponse implements ActionResponse.ErrorResponse {
        private final Set<String> invalidAddresses;

        public InvalidHostAddressesResponse(Set<String> invalidAddresses) {
            this.invalidAddresses = invalidAddresses;
        }

        @Description("Адреса хостов, которые не удалось распарсить")
        public Set<String> getInvalidAddresses() {
            return invalidAddresses;
        }

        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.FAIL;
        }

        @Override
        public Enum<?> getCode() {
            return Errors.INVALID_HOST_ADDRESSES;
        }

        @Override
        public Enum<?> getSubsystem() {
            return WebmasterCommonErrorSystem.REQUEST;
        }

        @Override
        public Class<?> getClazz() {
            return null;
        }

        @Override
        public String getMessage() {
            return "Failed to parse " + invalidAddresses.size() + " host addresses";
        }

        @Override
        public String getStackTrace() {
            return null;
        }
    }
}
