package ru.yandex.webmaster3.internal.user.host;

import jdk.jfr.Description;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.internal.common.InternalAction;
import ru.yandex.webmaster3.internal.common.security.ActionInternalGrant;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;
import ru.yandex.webmaster3.storage.iks.IksService;

@ReadAction
@Description("ручка для получения ИКС")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@ActionInternalGrant(InternalGrant.USER_HOST)
@Component("/host/getIks")
public class GetIksAction extends InternalAction<GetIksRequest, GetIksResponse> {
    private final IksService iksService;

    @Override
    public GetIksResponse process(GetIksRequest request) throws WebmasterException {
        String host = request.getHost();
        WebmasterHostId hostId = IdUtils.urlToHostId(host);
        int iks = iksService.getIksValue(hostId);
        return new GetIksResponse(iks);
    }
}
