package ru.yandex.webmaster3.internal.user.host;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.internal.common.InternalAction;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;

/**
 * @author avhaliullin
 */
@Description("Проверить, подтверждены ли права на хост у пользователя")
@ReadAction
public class HostIsVerifiedByUserAction extends InternalAction<HostIsVerifiedByUserRequest, HostIsVerifiedByUserResponse> {
    private UserHostsService userHostsService;

    public HostIsVerifiedByUserAction() {
        super(InternalGrant.USER_HOST);
    }

    @Override
    public HostIsVerifiedByUserResponse process(HostIsVerifiedByUserRequest request) throws WebmasterException {
        WebmasterHostId hostId = request.getHostAddress().getHostId();
        UserVerifiedHost userVerifiedHost = userHostsService.getVerifiedHost(
                new WebmasterUser(request.getUserId()),
                hostId
        );
        boolean verified = userVerifiedHost != null && (userVerifiedHost.getVerificationType().isDisplayable() ||
                request.isShowInvisible());
        return new HostIsVerifiedByUserResponse(verified, IdUtils.hostIdToUrl(hostId));
    }

    @Required
    public void setUserHostsService(UserHostsService userHostsService) {
        this.userHostsService = userHostsService;
    }
}
