package ru.yandex.webmaster3.internal.user.host;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.internal.common.data.HostAddress;
import ru.yandex.webmaster3.internal.common.request.AbstractUserRequest;

/**
 * @author avhaliullin
 */
public class HostIsVerifiedByUserRequest extends AbstractUserRequest {
    private HostAddress hostAddress;
    private boolean showInvisible = false;

    public HostAddress getHostAddress() {
        return hostAddress;
    }

    @Description("Адрес хоста")
    @RequestQueryProperty(required = true)
    public void setHostAddress(HostAddress hostAddress) {
        this.hostAddress = hostAddress;
    }

    public boolean isShowInvisible() {
        return showInvisible;
    }

    @Description("Учитывать ли специальные виды подтверждений")
    @RequestQueryProperty()
    public void setShowInvisible(boolean showInvisible) {
        this.showInvisible = showInvisible;
    }
}
