package ru.yandex.webmaster3.internal.user.host;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public class HostIsVerifiedByUserResponse implements ActionResponse {
    private final boolean verified;
    private final String hostAddress;

    public HostIsVerifiedByUserResponse(boolean verified, String hostAddress) {
        this.verified = verified;
        this.hostAddress = hostAddress;
    }

    @Description("Хост подтвержден пользователем")
    public boolean isVerified() {
        return verified;
    }

    @Description("Адрес хоста")
    public String getHostAddress() {
        return hostAddress;
    }

    @Override
    public ActionStatus getRequestStatus() {
        return ActionStatus.SUCCESS;
    }
}
