package ru.yandex.webmaster3.internal.user.host;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.internal.common.InternalAction;
import ru.yandex.webmaster3.internal.common.security.ActionInternalGrant;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Получить список сайтов, подтвержденных пользователем")
@ActionInternalGrant(InternalGrant.USER_HOST)
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ListUserHostsAction extends InternalAction<ListUserHostsRequest, ListUserHostsResponse> {

    private final UserHostsService userHostsService;

    @Override
    public ListUserHostsResponse process(ListUserHostsRequest request) throws WebmasterException {
        List<UserVerifiedHost> hosts = userHostsService.getVerifiedHosts(new WebmasterUser(request.getUserId()));
        if (!request.isShowInvisible()) {
            hosts = hosts.stream().filter(uh -> uh.getVerificationType().isDisplayable()).collect(Collectors.toList());
        }
        return new ListUserHostsResponse(
                hosts.stream()
                        .map(uh -> new VerifiedHost(
                                uh.getWebmasterHostId(),
                                uh.getVerificationDate().toInstant()
                        ))
                        .collect(Collectors.toList())
        );
    }
}
