package ru.yandex.webmaster3.internal.user.host;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.internal.common.data.HostAddress;

/**
 * @author avhaliullin
 */
public class UserHostQuery {
    @Description("адрес хоста")
    private final String hostAddress;
    @Description("id пользователя")
    private final long userId;

    @JsonCreator
    public UserHostQuery(
            @JsonProperty(required = true) String hostAddress,
            @JsonProperty(required = true) long userId
    ) {
        this.hostAddress = hostAddress;
        this.userId = userId;
    }

    public String getHostAddress() {
        return hostAddress;
    }

    public long getUserId() {
        return userId;
    }
}
