package ru.yandex.webmaster3.internal.user.host;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author avhaliullin
 */
public class UserHostResult {
    private final long userId;
    private final String hostAddress;
    private final boolean verified;

    public UserHostResult(long userId, String hostAddress, boolean verified) {
        this.userId = userId;
        this.hostAddress = hostAddress;
        this.verified = verified;
    }

    @Description("id пользователя")
    public long getUserId() {
        return userId;
    }

    @Description("адрес хоста (как в запросе)")
    public String getHostAddress() {
        return hostAddress;
    }

    @Description("подтвержден ли хост пользователем")
    public boolean isVerified() {
        return verified;
    }
}
