package ru.yandex.webmaster3.internal.user.host;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

@Getter
public class VerifiedHost {
    @Description("id сайта в вебмастере")
    private final WebmasterHostId hostId;
    @Description("URL хоста в unicode, например https://яндекс.рф или https://yandex.ru")
    private final String readableHostUrl;
    @Description("URL хоста в punicode, например https://xn--d1acpjx3f.xn--p1ai или https://yandex.ru")
    private final String punicodeHostUrl;
    @Description("Имя хоста в unicode, например яндекс.рф или yandex.ru")
    private final String readableHostname;
    @Description("Имя хоста в punicode, например xn--d1acpjx3f.xn--p1ai или yandex.ru")
    private final String punicodeHostname;
    @Description("Дата последней успешной проверки")
    private final Instant verifiedAt;

    public VerifiedHost(WebmasterHostId hostId, Instant verifiedAt) {
        this.hostId = hostId;
        this.readableHostUrl = IdUtils.hostIdToReadableUrl(hostId);
        this.punicodeHostUrl = IdUtils.hostIdToUrl(hostId);
        this.readableHostname = hostId.getReadableHostname();
        this.punicodeHostname = hostId.getPunycodeHostname();
        this.verifiedAt = verifiedAt;
    }
}