package ru.yandex.webmaster3.internal.user.host.verification;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * Created by leonidrom on 14/06/2017.
 */
public abstract class AddHostResponse implements ActionResponse {
    public static class NormalResponse extends AddHostResponse implements ActionResponse.NormalResponse {
        private final WebmasterHostId hostId;
        private final boolean verified;

        public NormalResponse(WebmasterHostId hostId, boolean verified) {
            this.hostId = hostId;
            this.verified = verified;
        }

        @Description("id добавленного хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("права на хост автоматически подтверждены")
        public boolean isVerified() {
            return verified;
        }
    }

    public enum Errors {
        ADD_HOST__HOST_ALREADY_ADDED,
        ADD_HOST__NOT_MAIN_MIRROR,
        ADD_HOST__HOSTS_LIMIT_EXCEEDED,
    }

    public abstract static class AbstractErrorResponse extends AddHostResponse implements ActionResponse.ErrorResponse {
        private final Errors code;

        public AbstractErrorResponse(Errors code) {
            this.code = code;
        }

        @Override
        public Enum<?> getCode() {
            return code;
        }
    }

    @Description("Такой хост уже добавлен")
    public static class HostAlreadyAddedError extends AbstractErrorResponse {
        private final WebmasterHostId hostId;
        private final boolean verified;

        public HostAlreadyAddedError(WebmasterHostId hostId, boolean verified) {
            super(Errors.ADD_HOST__HOST_ALREADY_ADDED);
            this.hostId = hostId;
            this.verified = verified;
        }

        @Description("id хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("подтвержден ли добавленный хост")
        public boolean isVerified() {
            return verified;
        }
    }

    @Description("Превышен лимит количества хостов")
    public static class HostsLimitExceededError extends AbstractErrorResponse {
        private final int limit;

        public HostsLimitExceededError(int limit) {
            super(Errors.ADD_HOST__HOSTS_LIMIT_EXCEEDED);
            this.limit = limit;
        }

        @Description("лимит количества хостов")
        public int getLimit() {
            return limit;
        }
    }
}

