package ru.yandex.webmaster3.internal.user.host.verification;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationTypeScope;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.internal.common.InternalAction;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;
import ru.yandex.webmaster3.storage.verification.HostVerifierService;

/**
 * Created by leonidrom on 14/06/2017.
 */
@Description("Выводит список типов подтверждений, доступных для выбранного хоста")
@ReadAction
public class ApplicableVerificationsAction extends InternalAction<ApplicableVerificationsRequest, ApplicableVerificationsResponse> {
    ApplicableVerificationsAction() {
        super(InternalGrant.HOST_VERIFICATION);
    }

    private HostVerifierService hostVerifierService;

    @Override
    public ApplicableVerificationsResponse process(ApplicableVerificationsRequest request) {
        return new ApplicableVerificationsResponse(hostVerifierService.listApplicable(
                request.getHostId(), request.getUserId(), VerificationTypeScope.INTERNAL
        ));
    }

    @Required
    public void setHostVerifierService(HostVerifierService hostVerifierService) {
        this.hostVerifierService = hostVerifierService;
    }
}
