package ru.yandex.webmaster3.internal.user.takeout;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.WebmasterUserIdAware;
import ru.yandex.webmaster3.internal.common.InternalRequest;

/**
 * @author leonidrom
 */
public class UserTakeoutDeleteStatusRequest extends InternalRequest implements WebmasterUserIdAware {
    private String request_id;
    private long userId;

    @RequestQueryProperty(required = true)
    @Description("Для логирования и кросс-сервисного дебага")
    public void setRequest_id(String request_id) {
        this.request_id = request_id;
    }

    public String getRequestId() {
        return request_id;
    }

    @Override
    @RequestQueryProperty()
    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Override
    public long getUserId() {
        return userId;
    }
}