package ru.yandex.webmaster3.internal.user.takeout;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.util.ArrayList;
import java.util.List;

/**
 * @author leonidrom
 */
public class UserTakeoutDeleteStatusResponse implements ActionResponse.NormalResponse {
    @Override
    public boolean isUndecoratedResponse() {
        return true;
    }

    public static class NormalResponse extends UserTakeoutDeleteStatusResponse {
        private final String status = "ok";
        private final JsonNode data;

        public NormalResponse(JsonNode data) {
            this.data = data;
        }

        public String getStatus() {
            return status;
        }

        public JsonNode getData() {
            return data;
        }
    }

    // Вебмастерский формат ошибок здесь не подходит, поэтому так
    public static class ErrorResponse extends UserTakeoutDeleteStatusResponse  {
        private final String status = "error";
        private final List<ErrEntry> errors;

        public ErrorResponse(String code, String message) {
            errors = new ArrayList<>();
            errors.add(new ErrEntry(code, message));
        }

        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.ERROR;
        }

        public String getStatus() {
            return status;
        }

        public List<ErrEntry> getErrors() {
            return errors;
        }
    }

   @Data
   private static class ErrEntry {
        private final String code;
        private final String message;
   }
}