package ru.yandex.webmaster3.internal.user.takeout;

import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.Map;

/**
 * @author leonidrom
 */
public abstract class UserTakeoutGetResponse implements ActionResponse.NormalResponse {
    @Override
    public boolean isUndecoratedResponse() {
        return true;
    }

    public static class NormalResponse extends UserTakeoutGetResponse {
        private final String status = "ok";
        private final Map<String, String> data;

        public NormalResponse(Map<String, String> data) {
            this.data = data;
        }

        public Map<String, String> getData() {
            return data;
        }

        public String getStatus() {
            return status;
        }
    }

    public static class RequestPendingResponse extends UserTakeoutGetResponse {
        private final String status = "pending";

        public String getStatus() {
            return status;
        }
    }

    public static class NoUserDataResponse extends UserTakeoutGetResponse {
        private final String status = "no_data";

        public String getStatus() {
            return status;
        }
    }
}
