package ru.yandex.webmaster3.internal.user.takeout;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.internal.common.InternalRequest;

/**
 * @author leonidrom
 */
public class UserTakeoutNewRequest extends InternalRequest {
    private long uid;
    private long unixtime;

    @RequestQueryProperty(required = true)
    @Description("Идентификатор пользователя. Может не быть пользователем Вебмастера")
    public void setUid(long uid) {
        this.uid = uid;
    }

    @RequestQueryProperty()
    @Description("Время запроса данных пользователем")
    public void setUnixtime(long unixtime) {
        this.unixtime = unixtime;
    }

    public long getUid() {
        return uid;
    }

    public long getUnixtime() {
        return unixtime;
    }
}
