package ru.yandex.webmaster3.internal.user.takeout;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.util.UUID;

/**
 * @author leonidrom
 */
public class UserTakeoutNewResponse implements ActionResponse.NormalResponse {
    private final String status = "ok";
    private final UUID jobId;

    public UserTakeoutNewResponse(UUID jobId) {
        this.jobId = jobId;
    }

    public String getStatus() {
        return status;
    }

    @JsonProperty("job_id")
    @Description("Идентификатор задачи на выгрузку")
    public UUID getJobId() {
        return jobId;
    }

    @Override
    public boolean isUndecoratedResponse() {
        return true;
    }
}
