package ru.yandex.webmaster3.monitoring.common;

import java.util.concurrent.TimeUnit;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.searchbase.SearchBaseDates;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.searchbase.dao.SearchBaseUpdatesYDao;

/**
 * По техническим причинам мы не хотим зависеть от сервисов, поэтому используем здесь копию
 */
public class MonSearchBaseUpdatesService {
    private final Duration CACHE_TTL = Duration.standardMinutes(1);
    private SearchBaseUpdatesYDao searchBaseUpdatesYDao;


    private final Supplier<SearchBaseDates> cache =
            Suppliers.memoizeWithExpiration(this::getDirectly, CACHE_TTL.getStandardSeconds(), TimeUnit.SECONDS);

    private SearchBaseDates getDirectly() {
        try {
            return SearchBaseDates.fromBaseInfos(searchBaseUpdatesYDao.getUpdatesHistory().values());
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to get search base updates",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    SearchBaseDates getSearchBaseUpdates() {
        return cache.get().atMomentOfTime(Instant.now().minus(CACHE_TTL));
    }

    @Required
    public void setSearchBaseUpdatesYDao(SearchBaseUpdatesYDao searchBaseUpdatesYDao) {
        this.searchBaseUpdatesYDao = searchBaseUpdatesYDao;
    }
}
