package ru.yandex.webmaster3.monitoring.dashboard;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class ZombDashboardHandler extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ZombDashboardHandler.class);
    private static String REQ_PATH_PREFIX = "/zomb/";
    private static String RESOURCE_PATH_PREFIX = "zomb/";

    private static final Map<String, String> RESOURCES_BY_TARGET = ImmutableMap.<String, String>builder()
            .put("misc.html", "misc.html")
            .put("mon-rot.js", "mon-rot.js")
            .put("mon-style.css", "mon-style.css")
            .put("webmaster-infra.html", "webmaster-infra.html")
            .put("webmaster-old-db.html", "webmaster-old-db.html")
            .put("webmaster-service.html", "webmaster-service.html")
            .put("xmlsearch-triggers.html", "xmlsearch-triggers.html")
            .put("sitesearch-triggers.html", "sitesearch-triggers.html")
            .build();

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!target.startsWith(REQ_PATH_PREFIX)) {
            return;
        }
        target = target.substring(REQ_PATH_PREFIX.length());
        String resource = RESOURCES_BY_TARGET.get(target);
        if (resource != null) {
            openPage(resource, baseRequest, response);
        }
    }

    private void openPage(String resource, Request baseRequest, HttpServletResponse response) throws IOException {
        baseRequest.setHandled(true);
        response.setStatus(HttpServletResponse.SC_OK);
        if (resource.endsWith(".html")) {
            response.setContentType(ContentType.TEXT_HTML.getMimeType());
        } else if (resource.endsWith(".js")) {
            response.setContentType(ContentType.create(
                    "application/javascript", Consts.UTF_8).getMimeType());
        } else if (resource.endsWith(".css")) {
            response.setContentType(ContentType.create(
                    "text/css", Consts.UTF_8).getMimeType());
        } else {
            response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
        }
        InputStream is = getClass().getClassLoader().getResourceAsStream(RESOURCE_PATH_PREFIX + resource);
        PrintWriter writer = response.getWriter();
        IOUtils.copy(is, writer, Charsets.UTF_8);
        writer.flush();
    }
}
