package ru.yandex.webmaster3.monitoring.queue.delurl;

import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.solomon.HandleCommonMetricsService;

/**
 * Created by ifilippov5 on 03.05.17.
 */
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Service
public class DelUrlPushMetricsService {
    private static final Logger log = LoggerFactory.getLogger(DelUrlPushMetricsService.class);
    @Value("${webmaster3.monitoring.solomon.delurl.enabled}")
    private boolean enabled;
    @Value("${webmaster3.monitoring.queue.delurl.refresh.interval.seconds}")
    private long refreshIntervalSeconds;

    private final DelUrlPrefixMonitoringService delUrlPrefixMonitoringService;
    private final HandleCommonMetricsService handleCommonMetricsService;

    @Scheduled(cron = "${webmaster3.monitoring.queue.delurl.refresh.cron}")
    private void push() throws Exception {
        if (!enabled) {
            log.warn("Delurl push metrics service disabled");
            return;
        }
        handleCommonMetricsService.handle(delUrlPrefixMonitoringService.createDelurlSensors(refreshIntervalSeconds), delUrlPrefixMonitoringService.getDelUrlSensorsSize());
    }
}
