package ru.yandex.webmaster3.monitoring.queue.sitemap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.scheduling.annotation.Scheduled;
import ru.yandex.webmaster3.core.solomon.SolomonSensor;
import ru.yandex.webmaster3.core.solomon.Indicators;
import ru.yandex.webmaster3.monitoring.common.YtQueueUtils;
import ru.yandex.webmaster3.core.solomon.HandleCommonMetricsService;
import ru.yandex.webmaster3.storage.util.yt.YtPath;
import ru.yandex.webmaster3.storage.util.yt.YtService;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by leonidrom on 11/07/2017.
 */
public class SitemapMonitoringService {
    private static final Logger log = LoggerFactory.getLogger(SitemapMonitoringService.class);

    private static final int AVERAGE_SENSORS_SIZE = 600;
    private static final String SECTION_LABEL_VALUE = "sitemap";
    private static final String YT_QUEUE_TYPE = "yt_queue";

    private HandleCommonMetricsService handleCommonMetricsService;
    private YtService ytService;
    private YtPath ytRequestsPath;

    private boolean enabled;
    private long refreshIntervalSeconds;

    @Scheduled(cron = "${webmaster3.monitoring.solomon.sitemap.refresh-cron}")
    private void push() throws Exception {
        if (!enabled) {
            return;
        }

        List<SolomonSensor> sensors = new ArrayList<>();

        YtQueueUtils.QueueStats unprocessedYtRequestsStats = YtQueueUtils.getQueueStats(
                ytService, ytRequestsPath, YtQueueUtils.ALL_TABLES_FILTER, YtQueueUtils.UNIX_TIMESTAMP_EXTRACTOR);
        sensors.add(SolomonSensor.createAligned(refreshIntervalSeconds, unprocessedYtRequestsStats.tablesCount)
                .withLabel(SolomonSensor.LABEL_SECTION, SECTION_LABEL_VALUE)
                .withLabel(SolomonSensor.LABEL_DATA_TYPE, YT_QUEUE_TYPE)
                .withLabel(SolomonSensor.LABEL_INDICATOR, Indicators.QUEUE_SIZE));
        sensors.add(SolomonSensor.createAligned(refreshIntervalSeconds, unprocessedYtRequestsStats.maxAgeInMillis / 1000)
                .withLabel(SolomonSensor.LABEL_SECTION, SECTION_LABEL_VALUE)
                .withLabel(SolomonSensor.LABEL_DATA_TYPE, YT_QUEUE_TYPE)
                .withLabel(SolomonSensor.LABEL_INDICATOR, Indicators.DATA_AGE));

        handleCommonMetricsService.handle(sensors, AVERAGE_SENSORS_SIZE);
    }

    @Required
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Required
    public void setRefreshIntervalSeconds(long refreshIntervalSeconds) {
        this.refreshIntervalSeconds = refreshIntervalSeconds;
    }

    @Required
    public void setHandleCommonMetricsService(HandleCommonMetricsService handleCommonMetricsService) {
        this.handleCommonMetricsService = handleCommonMetricsService;
    }

    @Required
    public void setYtService(YtService ytService) {
        this.ytService = ytService;
    }

    @Required
    public void setYtRequestsPath(YtPath ytRequestsPath) {
        this.ytRequestsPath = ytRequestsPath;
    }
}
