package ru.yandex.webmaster3.monitoring.sitemap;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.scheduling.annotation.Scheduled;

import ru.yandex.webmaster3.core.solomon.HandleCommonMetricsService;
import ru.yandex.webmaster3.core.solomon.Indicators;
import ru.yandex.webmaster3.core.solomon.SolomonSensor;
import ru.yandex.webmaster3.storage.host.CommonDataState;
import ru.yandex.webmaster3.storage.host.CommonDataType;
import ru.yandex.webmaster3.storage.settings.dao.CommonDataStateYDao;


public class SitemapCheckExportService {


    private static final String SECTION_LABEL_VALUE = "sitemap";
    private static final String LAST_SITEMAP_DATA_EXPORT_DATA_TYPE = "last_sitemap_data_export";
    private static final String LAST_HOST_DATA_EXPORT_TYPE = "last_host_data_export";
    private static final int AVERAGE_SENSORS_SIZE = 600;

    private HandleCommonMetricsService handleCommonMetricsService;
    private CommonDataStateYDao commonDataStateYDao;

    private boolean enabled;
    private long refreshIntervalSeconds;

    @Scheduled(cron = "${webmaster3.monitoring.solomon.sitemap.refresh-cron}")
    private void push() throws Exception {
        if (!enabled) {
            return;
        }

        long now = System.currentTimeMillis();
        List<SolomonSensor> sensors = new ArrayList<>();


        CommonDataState sitemapCds = commonDataStateYDao.getValue(CommonDataType.LAST_SITEMAP_DATA_EXPORT_DATE);
        long lastSitemapExport = sitemapCds == null ? 0L : sitemapCds.getLastUpdate().getMillis();
        sensors.add(SolomonSensor.createAligned(refreshIntervalSeconds, (now - lastSitemapExport) / 1000L)
                .withLabel(SolomonSensor.LABEL_SECTION, SECTION_LABEL_VALUE)
                .withLabel(SolomonSensor.LABEL_INDICATOR, Indicators.DATA_AGE)
                .withLabel(SolomonSensor.LABEL_DATA_TYPE, LAST_SITEMAP_DATA_EXPORT_DATA_TYPE));



        CommonDataState hostDataCds = commonDataStateYDao.getValue(CommonDataType.LAST_HOST_DATA_EXPORT_DATE);
        long lastHostDataExport = hostDataCds == null ? 0L : hostDataCds.getLastUpdate().getMillis();
        sensors.add(SolomonSensor.createAligned(refreshIntervalSeconds, (now - lastHostDataExport) / 1000L)
                .withLabel(SolomonSensor.LABEL_SECTION, SECTION_LABEL_VALUE)
                .withLabel(SolomonSensor.LABEL_INDICATOR, Indicators.DATA_AGE)
                .withLabel(SolomonSensor.LABEL_DATA_TYPE, LAST_HOST_DATA_EXPORT_TYPE));

        handleCommonMetricsService.handle(sensors, AVERAGE_SENSORS_SIZE);
    }

    @Required
    public void setHandleCommonMetricsService(HandleCommonMetricsService handleCommonMetricsService) {
        this.handleCommonMetricsService = handleCommonMetricsService;
    }

    @Required
    public void setCommonDataStateYDao(CommonDataStateYDao commonDataStateYDao) {
        this.commonDataStateYDao = commonDataStateYDao;
    }

    @Required
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Required
    public void setRefreshIntervalSeconds(long refreshIntervalSeconds) {
        this.refreshIntervalSeconds = refreshIntervalSeconds;
    }
}
