package ru.yandex.webmaster3.monitoring.solomon.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.solomon_api.model.SolomonTriggerParameterDto;

/**
 * Эти классы нужы, потому что мы не хотим полагаться на dto-классы сгенерированные из соломоновой спеки,
 * когда речь идет о хранении данных в нашей БД
 * @author avhaliullin
 */
public class SerializableTriggerParameter {
    private final String name;
    private final String selector;

    @JsonCreator
    public SerializableTriggerParameter(String name, String selector) {
        this.name = name;
        this.selector = selector;
    }

    public String getName() {
        return name;
    }

    public String getSelector() {
        return selector;
    }

    public SolomonTriggerParameterDto toApiDto() {
        return new SolomonTriggerParameterDto().name(name).selector(selector);
    }
}
