package ru.yandex.webmaster3.monitoring.solomon.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.solomon_api.model.SolomonTriggerVariableDto;

/**
 * Эти классы нужы, потому что мы не хотим полагаться на dto-классы сгенерированные из соломоновой спеки,
 * когда речь идет о хранении данных в нашей БД
 * @author avhaliullin
 */
public class SerializableTriggerVariable {
    private final String name;
    private final String selector;
    private final String begin;
    private final String end;

    @JsonCreator
    public SerializableTriggerVariable(String name, String selector, String begin, String end) {
        this.name = name;
        this.selector = selector;
        this.begin = begin;
        this.end = end;
    }

    public String getName() {
        return name;
    }

    public String getSelector() {
        return selector;
    }

    public String getBegin() {
        return begin;
    }

    public String getEnd() {
        return end;
    }

    public SolomonTriggerVariableDto toApiDto() {
        return new SolomonTriggerVariableDto()
                .name(name)
                .selector(selector)
                .begin(begin)
                .end(end);
    }
}
