package ru.yandex.webmaster3.monitoring.solomon.trigger;

import org.apache.commons.lang3.tuple.Pair;
import ru.yandex.webmaster3.core.solomon.metric.SolomonKey;
import ru.yandex.webmaster3.core.util.W3Collectors;

import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class PropertyKey {
    private static final String SOLOMON_LABEL_PREFIX = "l.";

    private final Map<String, String> labels;

    private PropertyKey(Map<String, String> labels) {
        this.labels = labels;
    }

    public PropertyKey(SolomonKey solomonKey) {
        this(solomonKey.getLabels().entrySet()
                .stream()
                .map(e -> Pair.of(SOLOMON_LABEL_PREFIX + e.getKey(), e.getValue()))
                .collect(W3Collectors.toHashMap()));
    }

    public Map<String, String> getLabels() {
        return labels;
    }

    public PropertyKey withSolomonLabel(String name, String value) {
        return withLabel(SOLOMON_LABEL_PREFIX + name, value);
    }

    public PropertyKey withLabel(String name, String value) {
        Map<String, String> newMap = new HashMap<>(labels);
        newMap.put(name, value);
        return new PropertyKey(newMap);
    }
}
