package ru.yandex.webmaster3.monitoring.solomon.trigger;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.solomon_api.model.SolomonTriggerSubscriberDto;

/**
 * Created by ifilippov5 on 08.06.17.
 */
public class TriggerSubscriber {
    private final TriggerSubscriberType type;
    private final String id;

    @JsonCreator
    public TriggerSubscriber(TriggerSubscriberType type, String id) {
        this.type = type;
        this.id = id;
    }

    public TriggerSubscriberType getType() {
        return type;
    }

    public String getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TriggerSubscriber that = (TriggerSubscriber) o;

        if (type != that.type) return false;
        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        int result = type.hashCode();
        result = 31 * result + id.hashCode();
        return result;
    }

    public enum TriggerSubscriberType implements IntEnum {
        EMAIL(0),
        GOLEM_SMS(1);

        TriggerSubscriberType(int value) {
            this.value = value;
        }

        private final int value;

        @Override
        public int value() {
            return value;
        }

        public static final IntEnumResolver<TriggerSubscriberType> R = IntEnumResolver.r(TriggerSubscriberType.class);
    }

    public SolomonTriggerSubscriberDto toApiDto() {
        return new SolomonTriggerSubscriberDto()
                .id(id)
                .type(type.name());
    }
}
