package ru.yandex.webmaster3.monitoring.solomon.trigger.actions;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.monitoring.solomon.WebmasterTriggersService;
import ru.yandex.webmaster3.monitoring.solomon.trigger.data.WebmasterTriggerInfo;

/**
 * Created by ifilippov5 on 09.06.17.
 */
@WriteAction
public class AddTriggerAction extends Action<AddTriggerRequest, AddTriggerResponse> {
    private WebmasterTriggersService webmasterTriggersService;

    @Override
    public AddTriggerResponse process(AddTriggerRequest request) throws WebmasterException {
        if (!request.isAllowUpdate()) {
            WebmasterTriggerInfo triggerInfo = webmasterTriggersService.getTriggerInfo(request.getTriggerInfo().getId());
            if (triggerInfo != null) {
                return new AddTriggerResponse.TriggerAlreadyExists();
            }
        }
        webmasterTriggersService.updateTrigger(request.getTriggerInfo());
        return new AddTriggerResponse.NormalResponse();
    }

    @Required
    public void setWebmasterTriggersService(WebmasterTriggersService webmasterTriggersService) {
        this.webmasterTriggersService = webmasterTriggersService;
    }
}
