package ru.yandex.webmaster3.monitoring.solomon.trigger.actions;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.monitoring.solomon.trigger.data.WebmasterTriggerInfo;

/**
 * Created by ifilippov5 on 10.06.17.
 */
public class AddTriggerRequest implements ActionRequest {
    private WebmasterTriggerInfo triggerInfo;
    private boolean allowUpdate = false;

    @RequestPostProperty(required = true)
    public void setTriggerInfo(WebmasterTriggerInfo triggerInfo) {
        this.triggerInfo = triggerInfo;
    }

    public WebmasterTriggerInfo getTriggerInfo() {
        return triggerInfo;
    }

    public boolean isAllowUpdate() {
        return allowUpdate;
    }

    @RequestQueryProperty
    @Description("если false - вернуть ошибку, если триггер уже существует")
    public void setAllowUpdate(boolean allowUpdate) {
        this.allowUpdate = allowUpdate;
    }
}
