package ru.yandex.webmaster3.monitoring.solomon.trigger.actions;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class AddTriggerResponse implements ActionResponse {
    public static class NormalResponse extends AddTriggerResponse {
        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }

    public enum Errors {
        ADD_TRIGGER__ALREADY_EXISTS,
    }

    public static class TriggerAlreadyExists extends AddTriggerResponse implements ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return Errors.ADD_TRIGGER__ALREADY_EXISTS;
        }
    }
}
