package ru.yandex.webmaster3.monitoring.solomon.trigger.actions;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * Created by ifilippov5 on 12.06.18.
 */
public abstract class CopyTriggerResponse implements ActionResponse {
    public static class NormalResponse extends CopyTriggerResponse {
        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }

    public enum Errors {
        SOURCE_TRIGGER__NOT_EXISTS,
        TRIGGER__ALREADY_EXISTS,
    }

    public static class SourceTriggerNotExists extends CopyTriggerResponse implements ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return Errors.SOURCE_TRIGGER__NOT_EXISTS;
        }
    }

    public static class TriggerAlreadyExists extends CopyTriggerResponse implements ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return Errors.TRIGGER__ALREADY_EXISTS;
        }
    }

}
