package ru.yandex.webmaster3.monitoring.solomon.trigger.actions;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.monitoring.solomon.WebmasterTriggersService;
import ru.yandex.webmaster3.monitoring.solomon.trigger.actions.DeleteTriggerAction.Request;
import ru.yandex.webmaster3.monitoring.solomon.trigger.actions.DeleteTriggerAction.Response;

/**
 * Created by Oleg Bazdyrev on 13/06/2017.
 */
@WriteAction
@Description("Удаление триггера Solomon по id")
public class DeleteTriggerAction extends Action<Request, Response> {
    private WebmasterTriggersService webmasterTriggersService;

    @Override
    public Response process(Request request) throws WebmasterException {
        webmasterTriggersService.deleteTrigger(request.id);
        return new Response();
    }

    public static class Request implements ActionRequest {
        private String id;

        @RequestQueryProperty(required = true)
        @Description("Идентификатор удаляемого триггера")
        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }

    @Required
    public void setWebmasterTriggersService(WebmasterTriggersService webmasterTriggersService) {
        this.webmasterTriggersService = webmasterTriggersService;
    }
}
