package ru.yandex.webmaster3.monitoring.solomon.trigger.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.monitoring.solomon.api.model.SerializableTriggerParameter;
import ru.yandex.webmaster3.monitoring.solomon.api.model.SerializableTriggerVariable;

import java.util.List;
import java.util.Optional;

/**
 * @author avhaliullin
 */
public class CustomTrigger extends WebmasterTrigger {
    private final String programRed;
    private final String programYellow;
    private final Optional<String> programDisplay;
    private final List<SerializableTriggerVariable> variables;
    private final List<SerializableTriggerParameter> parameters;

    @JsonCreator
    public CustomTrigger(String programRed, String programYellow, Optional<String> programDisplay,
                         List<SerializableTriggerVariable> variables,
                         List<SerializableTriggerParameter> parameters) {
        super(WebmasterTriggerType.CUSTOM);
        this.programRed = programRed;
        this.programYellow = programYellow;
        this.programDisplay = programDisplay;
        this.variables = variables;
        this.parameters = parameters;
    }

    public String getProgramRed() {
        return programRed;
    }

    public String getProgramYellow() {
        return programYellow;
    }

    public Optional<String> getProgramDisplay() {
        return programDisplay;
    }

    public List<SerializableTriggerVariable> getVariables() {
        return variables;
    }

    public List<SerializableTriggerParameter> getParameters() {
        return parameters;
    }
}
