package ru.yandex.webmaster3.monitoring.solomon.trigger.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.Duration;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public class DataAgeTrigger extends WebmasterTrigger {
    private final Optional<Duration> redThreshold;
    private final Optional<Duration> yellowThreshold;

    @JsonCreator
    public DataAgeTrigger(Optional<Duration> redThreshold, Optional<Duration> yellowThreshold) {
        super(WebmasterTriggerType.DATA_AGE);
        this.redThreshold = redThreshold;
        this.yellowThreshold = yellowThreshold;
    }

    public Optional<Duration> getRedThreshold() {
        return redThreshold;
    }

    public Optional<Duration> getYellowThreshold() {
        return yellowThreshold;
    }
}
