package ru.yandex.webmaster3.monitoring.solomon.trigger.data;

import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.List;
import java.util.Optional;

/**
 * @author avhaliullin
 */
public class ErrorsRatioTrigger extends WebmasterTrigger {
    private final Optional<String> resultLabelName;
    private final List<String> errorValues;
    private final List<String> normalValues;
    private final Optional<Integer> redRatioThreshold;
    private final Optional<Integer> yellowRatioThreshold;

    @JsonCreator
    public ErrorsRatioTrigger(Optional<String> resultLabelName, List<String> errorValues, List<String> normalValues, Optional<Integer> redRatioThreshold, Optional<Integer> yellowRatioThreshold) {
        super(WebmasterTriggerType.ERROR_RATIO);
        this.resultLabelName = resultLabelName;
        this.errorValues = errorValues;
        this.normalValues = normalValues;
        this.redRatioThreshold = redRatioThreshold;
        this.yellowRatioThreshold = yellowRatioThreshold;
    }

    public Optional<String> getResultLabelName() {
        return resultLabelName;
    }

    public List<String> getErrorValues() {
        return errorValues;
    }

    public List<String> getNormalValues() {
        return normalValues;
    }

    public Optional<Integer> getRedRatioThreshold() {
        return redRatioThreshold;
    }

    public Optional<Integer> getYellowRatioThreshold() {
        return yellowRatioThreshold;
    }
}
