package ru.yandex.webmaster3.monitoring.solomon.trigger.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.Duration;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public class NoDataTrigger extends WebmasterTrigger {
    private final Optional<Duration> periodYellow;
    private final Optional<Duration> periodRed;

    @JsonCreator
    public NoDataTrigger(Optional<Duration> periodYellow, Optional<Duration> periodRed) {
        super(WebmasterTriggerType.NO_DATA);
        this.periodYellow = periodYellow;
        this.periodRed = periodRed;
    }

    public Optional<Duration> getPeriodYellow() {
        return periodYellow;
    }

    public Optional<Duration> getPeriodRed() {
        return periodRed;
    }
}
