package ru.yandex.webmaster3.monitoring.solomon.trigger.data;

import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public class QueueSizeTrigger extends WebmasterTrigger {
    private final Optional<Long> redThreshold;
    private final Optional<Long> yellowThreshold;

    @JsonCreator
    public QueueSizeTrigger(Optional<Long> redThreshold, Optional<Long> yellowThreshold) {
        super(WebmasterTriggerType.QUEUE_SIZE);
        this.redThreshold = redThreshold;
        this.yellowThreshold = yellowThreshold;
    }

    public Optional<Long> getRedThreshold() {
        return redThreshold;
    }

    public Optional<Long> getYellowThreshold() {
        return yellowThreshold;
    }
}
