package ru.yandex.webmaster3.monitoring.solomon.trigger.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.Duration;

import java.util.Optional;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class TimingsTrigger extends WebmasterTrigger {
    private final Optional<Duration> durationThreshold;
    private final Optional<Integer> redStatePercentile;
    private final Optional<Integer> yellowStatePercentile;
    private final Set<Duration> timeBuckets;

    @JsonCreator
    public TimingsTrigger(Optional<Duration> durationThreshold, Optional<Integer> redStatePercentile,
                          Optional<Integer> yellowStatePercentile, Set<Duration> timeBuckets) {
        super(WebmasterTriggerType.TIMINGS);
        this.durationThreshold = durationThreshold;
        this.redStatePercentile = redStatePercentile;
        this.yellowStatePercentile = yellowStatePercentile;
        this.timeBuckets = timeBuckets;
    }

    public Set<Duration> getTimeBuckets() {
        return timeBuckets;
    }

    public Optional<Duration> getDurationThreshold() {
        return durationThreshold;
    }

    public Optional<Integer> getRedStatePercentile() {
        return redStatePercentile;
    }

    public Optional<Integer> getYellowStatePercentile() {
        return yellowStatePercentile;
    }

    public TimingsTrigger withDurationThreshold(Duration durationThreshold) {
        return new TimingsTrigger(Optional.of(durationThreshold), redStatePercentile, yellowStatePercentile, timeBuckets);
    }
}
