package ru.yandex.webmaster3.monitoring.solomon.trigger.data;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.With;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Duration;

import ru.yandex.webmaster3.core.solomon.metric.SolomonKey;

/**
 * @author avhaliullin
 */
@With
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class WebmasterTriggerInfo {
    String id;
    String name;
    SolomonKey commonLabels;
    String project;
    String service;
    String host;
    String dashboardCategory;
    Duration dataDuration;
    WebmasterTrigger trigger;

    public WebmasterTriggerInfo(String id, String name, Map<String, String> commonLabels, String project, String service,
                                String host, String dashboardCategory, Duration dataDuration, WebmasterTrigger trigger) {
        this(id, name, SolomonKey.create(commonLabels), project, service, host, dashboardCategory, dataDuration, trigger);
    }

    public String getId() {
        return StringUtils.left(id, 64);
    }
}
