package ru.yandex.webmaster3.monitoring.solomon.trigger.data;

import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * @author avhaliullin
 */
public enum WebmasterTriggerType implements Discriminator<WebmasterTrigger> {
    TIMINGS(TimingsTrigger.class),
    ERROR_RATIO(ErrorsRatioTrigger.class),
    DATA_AGE(DataAgeTrigger.class),
    NO_DATA(NoDataTrigger.class),
    QUEUE_SIZE(QueueSizeTrigger.class),
    CUSTOM(CustomTrigger.class),
    BASIC(BasicTrigger.class)
    ;

    private final Class<? extends WebmasterTrigger> dataClass;

    WebmasterTriggerType(Class<? extends WebmasterTrigger> dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public Class<? extends WebmasterTrigger> getDataClass() {
        return dataClass;
    }
}
